//
//		Definition of the main game class
//
#ifndef THE_HELP_SCENE_H
#define THE_HELP_SCENE_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#include "../Utils/theStringManager.h"

class ldwButton;
class theGameState;
class ldwTextControl;

class theHelpScene : public ldwScene
{
public:

	theHelpScene();
	~theHelpScene();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);
	bool ForwardWaitingMessage(StringId whichMessage);


protected:

	void DrawScene();
	void UpdateScene();

private:

	ldwGameWindow    *gameWindow;
	theGameState     *gs;
	theStringManager *strMgr;

	int  pageNum;
	int  creditPageNumSave;
	bool fullScreenMode;
	bool pointerShowing;

	bool leftBtnHidden;
	bool rightBtnHidden;
 
	ldwTextControl *sceneLabel;

	const int doneButtonId;
	const int statsButtonId;
	const int rightNavBtnId;
	const int leftNavBtnId;

	ldwButton *doneButton;
	ldwButton *leftNavBtn;
	ldwButton *rightNavBtn;
	ldwButton *statsButton;
};
#endif